\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{cnkbook}[2016/05/24 CNC book class for NLN]

\LoadClass[a4paper,twoside,openany,10pt]{book}

\DeclareOption{textonly}{\def\TEXTONLYFLAG{}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{book}}
\ProcessOptions\relax

\RequirePackage{etoolbox} % better hooks for document front matter: e.g. \AfterEndPreamble
\RequirePackage{amsthm}
\RequirePackage{tipa} \let\ipa\textipa %IPA znaky
\RequirePackage{fontspec} % Font selection for XeLaTeX
\defaultfontfeatures{Mapping=tex-text} % to support TeX conventions like ``---''

%\RequirePackage[czech]{babel} %koliduje s kdovicimvsim...?
\RequirePackage{polyglossia}
\setdefaultlanguage{czech}
\RequirePackage{xevlna}

%definice uvozovek
\newcommand{\uv}[1]{\quotedblbase#1\/``}
\RequirePackage[autostyle=true]{csquotes}
\DeclareQuoteStyle{czech}
  {\quotedblbase}
  {\textquotedblleft}
  [0.05em]
  {\quotesinglbase}
  {\textquoteleft}

\RequirePackage{xunicode} 
\RequirePackage{xltxtra} % Extra customizations for XeLaTeX
\RequirePackage{graphicx}
\RequirePackage{geometry}
\RequirePackage{fancyhdr} % paginace
\RequirePackage{unicode-math}
\RequirePackage{remreset} % cislovani pozn. pod carou - pro TeXLive 2019 uz neni potreba
\RequirePackage{ifthen} % vyuziva conclist
\RequirePackage{booktabs} % tabulky
\RequirePackage{longtable}
\RequirePackage{caption} % popisky obrazku a tabulek
\RequirePackage[figuresright]{rotating} % landscape stranky
\RequirePackage{xcolor}

\frenchspacing

\geometry{
  paperwidth=150mm,
  paperheight=225mm,
  left=24mm,
  right=15mm,
  top=14mm,
  bottom=18.2mm,
  footskip=9mm
}

%%orezove znacky
\RequirePackage[cross,a4,center]{crop}
\makeatletter
\newcommand*\orezulc{%
\begin{picture}(0,0)
\unitlength\p@\thinlines
\put(-40,0){\circle{10}}
\put(-40,-5){\line(0,1){10}}
\put(-45,0){\line(1,0){22}}
\put(0,40){\circle{10}}
\put(-5,40){\line(1,0){10}}
\put(0,45){\line(0,-1){22}}
\end{picture}%
}
\newcommand*\orezurc{%
\begin{picture}(0,0)
\unitlength\p@\thinlines
\put(40,0){\circle{10}}
\put(40,-5){\line(0,1){10}}
\put(45,0){\line(-1,0){22}}
\put(0,40){\circle{10}}
\put(-5,40){\line(1,0){10}}
\put(0,45){\line(0,-1){22}}
\end{picture}%
}
\newcommand*\orezllc{%
\begin{picture}(0,0)
\unitlength\p@\thinlines
\put(-40,0){\circle{10}}
\put(-40,-5){\line(0,1){10}}
\put(-45,0){\line(1,0){22}}
\put(0,-40){\circle{10}}
\put(-5,-40){\line(1,0){10}}
\put(0,-45){\line(0,1){22}}
\end{picture}%
}
\newcommand*\orezlrc{%
\begin{picture}(0,0)
\unitlength\p@\thinlines
\put(40,0){\circle{10}}
\put(40,-5){\line(0,1){10}}
\put(45,0){\line(-1,0){22}}
\put(0,-40){\circle{10}}
\put(-5,-40){\line(1,0){10}}
\put(0,-45){\line(0,1){22}}
\end{picture}%
}
\cropdef\orezulc\orezurc\orezllc\orezlrc{orez}
\makeatother


% Definice barev
\definecolor{seda25}{cmyk}{0, 0, 0, 0.25}
\definecolor{seda50}{cmyk}{0, 0, 0, 0.5}


% Fonty
\setmainfont{Charis SIL} % Charis SIL
\setsansfont[BoldFont={* Bold}]{Myriad Pro} % Myriad Pro
\setmonofont{Cousine} %Courier
\setmathfont{Cambria Math} % pismo pro mat. vzorce
\makeatletter
\renewcommand\normalsize{%
\@setfontsize\normalsize{9pt}{11pt}% 
\abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@%
\abovedisplayshortskip \z@ \@plus2\p@%
\belowdisplayshortskip 5\p@ \@plus2\p@ \@minus3\p@%
\belowdisplayskip \abovedisplayskip%
\let\@listi\@listI%
}
\normalsize  
\makeatother
\renewcommand{\small}{\fontsize{8pt}{11pt}\selectfont}
\renewcommand{\footnotesize}{\fontsize{7pt}{8pt}\selectfont}
\newcommand{\smalltt}{\fontsize{8.5pt}{11pt}\selectfont}


% Zahlavi a zapati
\fancypagestyle{plain}{%
\fancyhf{} % clear all header and footer fields
\fancyfoot[LE,RO]{\normalsize\bf\textsf{\thepage}}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}}


%cara pod názvem kapitoly
\makeatletter
\newlength{\delkacary}
\setlength{\delkacary}{\textwidth}
\newlength{\presah}
\setlength{\presah}{20mm}
\newlength{\defaulthfuzz}
\setlength{\defaulthfuzz}{\hfuzz}
\newlength{\relaxhfuzz}
\setlength{\relaxhfuzz}{60pt}
\def\@makechapterhead#1{%
  {\hfuzz=\relaxhfuzz% suppress warnings
    \parindent \z@ \raggedright \normalfont%
    \interlinepenalty\@M%
    \ifodd\value{page}%
      \addtolength{\delkacary}{\presah}%
      \fontsize{16pt}{19pt}\selectfont \sf \bfseries \thechapter.~#1 \par%
      \raisebox{-2mm}{\color{seda25}\rule[6mm]{\delkacary}{3pt}}%
    \else\addtolength{\delkacary}{\presah}%
      \fontsize{16pt}{19pt}\selectfont \sf \bfseries \thechapter.~#1 \par%
      \hskip-\presah\raisebox{-2mm}{\color{seda25}\rule[6mm]{\delkacary}{3pt}}%
    \fi
    \vskip 14\p@\hfuzz=\defaulthfuzz% 19+14=33
  }}
\def\@makeschapterhead#1{%
  {\hfuzz=\relaxhfuzz% suppresss warnings
    \parindent \z@ \raggedright \normalfont %
    \interlinepenalty\@M
    \ifodd\value{page}%
      \addtolength{\delkacary}{17mm}%
      \fontsize{16pt}{19pt}\selectfont \sf \bfseries #1 \par%
      \raisebox{-2mm}{\color{seda25}\rule[6mm]{\delkacary}{3pt}}%
    \else\addtolength{\delkacary}{20mm}%
      \fontsize{16pt}{19pt}\selectfont \sf \bfseries #1 \par%
      \hskip-\presah\raisebox{-2mm}{\color{seda25}\rule[6mm]{\delkacary}{3pt}}%
    \fi
    \vskip 14\p@\hfuzz=\defaulthfuzz%
  }}
\makeatother


%ctverecek a cara u nazvu sekci, podsekci atd.
\setcounter{secnumdepth}{5}
\makeatletter
\renewcommand{\@seccntformat}[1]{\csname the#1\endcsname\ } % mezera mezi cislem a nazvem sec.
\newlength{\mylena}
\newlength{\mylenb}
\ifx\secindent\undefined \newdimen\secindent \newskip\secpreskp \newskip\secpstskp \newdimen\subindent \newskip\subpreskp \newskip\subpstskp \newskip\parpstskp \newcount\c@hddepth\fi
\let\LaTeX@startsection\@startsection 
\renewcommand{\@startsection}[6]{\LaTeX@startsection%
{#1}{#2}{#3}{#4}{#5}%
{\noindent%
\ifnum#2=1{% podsekce -> cara
  \ifodd\value{page}{%
    \settowidth{\mylena}{\fontsize{12pt}{13pt}\selectfont\sf\bfseries{\thesection}}%
    \setlength{\mylenb}{30mm}\addtolength{\mylenb}{\mylena}%
    \hskip-30mm\raisebox{-2.3mm}{\color{seda25}\rule{\mylenb}{2pt}}\hskip-\mylena%
  }\else{%
    \settowidth{\mylena}{\fontsize{12pt}{13pt}\selectfont\sf\bfseries\thesection}%
    \setlength{\mylenb}{20mm}\addtolength{\mylenb}{\mylena}%
    \hskip-20mm\raisebox{-2.3mm}{\color{seda25}\rule{\mylenb}{2pt}}\hskip-\mylena%
  }\fi%
}\fi%
\ifnum#2>1{% druha a dalsi uroven -> ctverecek
  \ifnum#2<5{% petka ale ne
    \setlength{\mylena}{4mm}%
    \settoheight{\mylenb}{\large x}%
    \addtolength{\mylena}{-\mylenb}%
    \hskip-4mm{\color{seda25}\rule{\mylenb}{\mylenb}}\hskip\mylena%
  }\fi%
}\fi#6}} 
\makeatother


%%zmensit mezery kolem nadpisu
\makeatletter
\renewcommand\section{\@startsection {section}{1}{\z@}% 
  {-22pt \@plus -6pt \@minus -2pt}% beforeskip: 2 radky
  {11pt \@plus 1pt}% afterskip: 1 radek
  {\fontsize{12pt}{13pt}\selectfont\sf\bfseries}} %
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
  {-15pt \@plus -2pt \@minus -1pt} % 15b
  {7pt \@plus 0pt} % 7b
  {\fontsize{9pt}{11pt}\selectfont\sf\bfseries}} %
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
  {-11pt\@plus -1pt \@minus -.5pt}% 1 radek
  {.01pt \@plus 0pt}% 0b
  {\fontsize{9pt}{11pt}\selectfont\sf\bfseries}}%
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
  {-11pt \@plus -1pt \@minus -.5pt}% 1 radek
  {.01pt \@plus 0pt}% 0b
  {\fontsize{9pt}{11pt}\selectfont\sf\bfseries\itshape}}%
\renewcommand\subparagraph{\@startsection{subparagraph}{5}{\z@}%
  {-11pt \@plus -1pt \@minus -.5pt}% neni definovano
  {.01pt \@plus 0pt}% neni definovano
  {\fontsize{9pt}{11pt}\selectfont\sf\bfseries\itshape}}% neni definovano
\makeatother


%zmensit mezery ve vyctu
\makeatletter
\def\@listi{\leftmargin\leftmargini
            \parsep 0\p@ \@plus0\p@ \@minus0\p@
            \topsep 0\p@ \@plus0\p@ \@minus0\p@
            \itemsep 2\p@ \@plus0\p@ \@minus0\p@}
\let\@listI\@listi
\@listi
\makeatother


% Poznamky pod carou (FN)
% FN: Kontinualni cislovani poznamek pod carou
\makeatletter
\@removefromreset{footnote}{chapter}

% FN: Umisteni cisla u poznamky pod carou
\newlength{\fnmarkindent}
\setlength{\fnmarkindent}{1em}
\renewcommand\@makefntext[1]{%
    \parindent 0em%
    \noindent
    \hb@xt@-\fnmarkindent{\hss\@thefnmark}\hspace{\fnmarkindent}#1} % cislo zarovnane vlevo

% FN: Delka cary oddelujici poznamky pod carou
\newlength{\fnrulelen}
\setlength{\fnrulelen}{20mm}
\newlength{\fnrulewid}
\setlength{\fnrulewid}{0.5pt}
\renewcommand\footnoterule{%
  \kern-3\p@
  \noindent\flushleft
  \rule{\fnrulelen}{\fnrulewid}
  \vspace{2pt}
  \kern3\p@}
\makeatother


%preformatovani obsahu
\addto\captionsczech{\renewcommand{\contentsname}{OBSAH}}
\setcounter{tocdepth}{2}
\makeatletter
\renewcommand\chapter{%
    \addtocontents{toc}{\protect\addvspace{11\p@}}% vlozeni prazdneho radku do TOC pred kapitolu
    \if@openright\cleardoublepage\else\clearpage\fi
                 \thispagestyle{plain}%
                 \global\@topnum\z@
                 \@afterindentfalse
                 \secdef\@chapter\@schapter%
}

\def\@chapter[#1]#2{%
  \ifnum \c@secnumdepth >\m@ne
  \if@mainmatter
    \refstepcounter{chapter}%
    \typeout{\@chapapp\space\thechapter.}%
    \addcontentsline{toc}{chapter}%
      {\protect\numberline{\thechapter.}#1}% tecka za cislem kapitoly
  \else
    \addcontentsline{toc}{chapter}{#1}%
  \fi
  \else
  \addcontentsline{toc}{chapter}{#1}%
  \fi
  \chaptermark{#1}%
  \addtocontents{lof}{\protect\addvspace{10\p@}}%
  \addtocontents{lot}{\protect\addvspace{10\p@}}%
  \if@twocolumn
  \@topnewpage[\@makechapterhead{#2}]%
  \else
  \@makechapterhead{#2}%
  \@afterheading
  \fi%
}

\renewcommand*\l@chapter[2]{\@dottedtocline{0}{0em}{1.6em}{\bfseries #1}{#2}} %
\renewcommand*\l@section{\@dottedtocline{1}{4mm}{2.2em}} % 2.8em
\renewcommand*\l@subsection{\@dottedtocline{2}{8mm}{3.2em}} % 3.7em
\renewcommand{\@dotsep}{10000} 
\renewcommand{\@pnumwidth}{2em} % velikost oblasti pro cisla stranek; default = 1.55em
\makeatother


%Plovouci prostredi
\newlength{\captindent}
\setlength{\captindent}{0.1em}
\makeatletter
\let\oldfigure\figure
\def\figure{\@ifnextchar[\figure@i \figure@ii}
\def\figure@i[#1]{\vspace{\captindent}\oldfigure[#1]\centering\vspace{\captindent}}
\def\figure@ii{\vspace{\captindent}\oldfigure\centering\vspace{\captindent}}

\let\oldtable\table
\def\table{\@ifnextchar[\table@i \table@ii}
\def\table@i[#1]{%
  \vspace{\captindent}%
  \oldtable[#1]\centering\fontsize{8pt}{9pt}\selectfont%
  \vspace{\captindent}}
\def\table@ii{%
  \vspace{\captindent}%
  \oldtable\centering\fontsize{8pt}{9pt}\selectfont%
  \vspace{\captindent}}
\makeatother

% Sirka car u tabulek
\setlength{\heavyrulewidth}{0.75pt}
\setlength{\lightrulewidth}{0.5pt}
\setlength{\cmidrulewidth}{0.3pt}


% Caption u obrázku a tabulek
\makeatletter
\@removefromreset{table}{chapter}
\@removefromreset{figure}{chapter}
\makeatother
\captionsetup[table]{format=hang, labelsep=period, font={small,sf}, labelfont={sf,bf}, name=Tab.}
\captionsetup[figure]{format=hang, labelsep=period, font={small,sf}, labelfont={sf,bf}, name=Obr.}

\renewcommand{\thetable}{\arabic{table}}
\renewcommand{\thefigure}{\arabic{figure}}


% Pretitle: Redakcni rada
\makeatletter
\newcommand*{\makepretitle}{%
  \begin{titlepage}
  \vspace*{23mm}%
  \setlength{\parindent}{0pt}%
  \hspace{16mm}\parbox{93mm}{%
  \raggedright%
  {\fontsize{14pt}{16pt}\selectfont\sf STUDIE Z KORPUSOVÉ LINGVISTIKY\par}
  \vspace{22pt}
  {\fontsize{10pt}{14pt}\selectfont\sf\itshape Redakční rada:\par
    \vspace{10pt}
    doc. RNDr. Vladimír Petkevič, CSc. (předseda)\par
    doc. Mgr. Václav Cvrček, Ph.D.\par
    prof. PhDr. František Čermák, DrSc.\par
    Mgr. Anna Čermáková, Ph.D.\par
    Mgr. Jan Kocek\par
    PhDr. Marie Kopřivová, Ph.D.\par
    Mgr. Michal Křen, Ph.D.\par
    prof. PhDr. Karel Kučera, CSc.\par
    Ing. Alexandr Rosen, Ph.D.\par
    Mgr. Pavel Vondřička, Ph.D.\par
    }
  }
  \end{titlepage}
}
\makeatother


% Title: Titulní strana
\makeatletter
\renewcommand*{\maketitle}{%
  \begin{titlepage}
  \vspace*{23mm}
  \setlength{\parindent}{0pt}
  \hspace{16mm}\parbox{93mm}{%
    \raggedright%
    {\color{seda50}\fontsize{30pt}{32pt}\selectfont\sf\addfontfeature{BoldFont={* Semibold}}\bfseries\@title \par}
    \vspace{1cm}
    {\fontsize{16pt}{18pt}\selectfont\sf\@author \par}
  }

  \vfill

  \hspace{16mm}\parbox{93mm}{%
    \includegraphics[width=41mm]{img/nln.png}
    \hspace{6mm}
    \raisebox{1.715mm}{\includegraphics[width=42.9mm]{img/CNK-sirka-02-bw-CMYK.eps}}
  }
  \vspace{11.8mm}
  \end{titlepage}
}
\makeatother


% Sazba konkordancnich seznamu - conclist a \concline
\newcommand{\refcncl}[4][]{\textsf{#1} & #2 & \textbf{#3} #4\\}
\newcommand{\cncl}[3]{#1 & \textbf{#2} #3\\}
\newenvironment{conclist}[1][noref]{%
  \vskip 1ex%
  \begin{footnotesize}%
  \begin{center}%
  \ifthenelse{\equal{#1}{noref}}{%
    \newcommand{\concline}{\cncl}%
    \begin{tabular}{@{}r@{\hspace{1ex}}l@{}}%
  }{%
    \newcommand{\concline}{\refcncl}%
    \begin{tabular}{@{}lr@{\hspace{1ex}}l@{}}}%
}{%
  \end{tabular}%
  \end{center}%
  \end{footnotesize}%
  \vskip 1ex%
}


% \cql - sazba príkazu CQL
\newcommand{\cql}[1]{\begin{smalltt}\texttt{\addfontfeatures{Mapping=}#1}\end{smalltt}}

% petit - prostredi pro priklady a drobne poznamky
\newenvironment{petit}{
  \setlength{\parindent}{0pt}
  \vskip 1ex
  \begin{small}\itshape
}{
  \end{small}
  \vskip 1ex
}


% Prostredi pro sazbu literatury
% propojeni s BibTeXem necht si doplní laskavy uzivatel sam
\newenvironment{biblio}{
  \begin{list}{}{%
    \setlength\topsep{0pt}\setlength\parsep{0pt}\setlength\parskip{0pt}\setlength\itemsep{0pt}\setlength\partopsep{0pt}%
    \setlength{\leftmargin}{4mm}\setlength{\itemindent}{-4mm}%
    \fontsize{8pt}{10pt}\selectfont}%
}{%
\end{list}\normalsize}


% Odsazeni textu jako kdyby na strance byl nadpis kapitoly
\newcommand{\topskipChapter}{% 
  \colorlet{sedaOld}{seda25}%
  \definecolor{seda25}{cmyk}{0, 0, 0, 0}%
  \chapter*{\color{seda25}Mj}%
  \colorlet{seda25}{sedaOld}%
}

% Info o knize
\makeatletter
\newcommand*{\isbn}[1]{\gdef\@isbn{#1}}
\newcommand*{\@isbn}{--- not set ---}
\newcommand*{\cena}[1]{\gdef\@cena{#1}}
\newcommand*{\@cena}{---}
\newcommand*{\redakce}[1]{\gdef\@redakce{#1}}
\newcommand*{\@redakce}{Vladimír Petkevič}
\newcommand*{\sazba}[1]{\gdef\@sazba{#1}}
\newcommand*{\@sazba}{Marie Tvrdá}
\newcommand*{\dedikace}[1]{\gdef\@dedikace{#1}}
\newcommand*{\@dedikace}{--- chybí dedikace ---}
\newcommand*{\recenzenti}[1]{\gdef\@recenzenti{#1}}
\newcommand*{\@recenzenti}{--- chybí recenzenti ---}
\newcommand*{\podekovani}[1]{\gdef\@podekovani{#1}}
\newcommand*{\@podekovani}{}

%\usepackage{showframe} % vlozi obrys sazebniho obrazce

%-----------------------------------------------------------------------------------------------
%---------------------------------        Front matter       -----------------------------------
%-----------------------------------------------------------------------------------------------

\AfterEndPreamble{

\crop[orez] % vlozi orezove znacky

\ifx\TEXTONLYFLAG\undefined
% ===== Titulní strany ================================

\makepretitle

\pagestyle{empty}

\maketitle

% ===== Dedikace ================================

\topskipChapter
\thispagestyle{empty}


\makeatletter
\@dedikace

\bigskip

\noindent Recenzenti:

\noindent \@recenzenti

\vfill

\noindent Cover © Michaela Blažejová, \@date\\
© Filozofická fakulta Univerzity Karlovy, \@date\\
Všechna práva vyhrazena.

\medskip

\noindent ISBN \@isbn
\makeatother

% ===== Podekovani ================================

\clearpage
\setcounter{page}{5}
\ifx\@podekovani\empty
\rule{0pt}{10pt}
\clearpage
\else
\pagestyle{plain}

\chapter*{Poděkování}

\@podekovani
\fi

\fi

% ===== Obsah ================================

\let\Oldnumberline\numberline
\renewcommand\numberline[1]{\Oldnumberline{\bfseries #1}} %tucna cisla sekci
\tableofcontents
\renewcommand{\numberline}{\Oldnumberline}

}

%-----------------------------------------------------------------------------------------------
%---------------------------------       Back matter       -------------------------------------
%-----------------------------------------------------------------------------------------------

\ifx\TEXTONLYFLAG\undefined
\AtEndDocument{

% ===== V NLN jiz vyslo - dodá NLN ================================

%\clearpage
%\pagestyle{empty}
%\include{supl/vyslo} % editovat prip. v souboru supl/vyslo

% ===== Tiráž ================================

%\clearpage
%\pagestyle{empty}
\include{supl/tiraz} % editovat prip. v souboru supl/tiraz

}
\fi
%-----------------------------------------------------------------------------------------------
%-----------------------------------------------------------------------------------------------
%-----------------------------------------------------------------------------------------------
